const http = require('http');
const path = require('path');
const fs = require('fs');

// Create server
const server = http.createServer((req, res) => {
    
    // NOT DYNAMIC WAY OF SERVING DATA

    // if (req.url === '/') {
    //     fs.readFile(path.join(__dirname, '7 - Node.js/public', 'index.html'), (err, content) => {
    //         if (err) throw err;
    //         res.writeHead(200, { 'Content-Type': 'text/html' });
    //         res.end(content);
    //     });
 
    // }

    // if (req.url === '/api/users') {

    //     const users = [
    //         { name: 'Paulo Cunha', age: 21 },
    //         { name: 'Henrique Costa', age: 25 }
    //     ];

    //     res.writeHead(200, { 'Content-Type': 'application/json'} );
    //     res.end(JSON.stringify(users));

    // }

    // MORE DYNAMIC WAY OF SERVING DATA

    // Build file path
    let filePath = path.join(__dirname, 
        '7 - Node.js/public', 
        req.url === '/' ? 'index.html' : req.url);
    
    // Get extension of the file
    let extname = path.extname(filePath);

    // Set initial content type
    let contentType = 'text/html';

    // Check extension and set the content type
    switch(extname) {
        case '.js':
            contentType = 'text/javascript';
            break;
        case '.css':
            contentType = 'text/css';
            break;
        case '.json':
            contentType = 'application/json';
            break;
        case '.png':
            contentType = 'image/png';
            break;
        case '.jpg':
            contentType = 'image/jpg';
            break;
    }

    // Read the file
    fs.readFile(filePath, (err, content) => {
        if (err) {
            if (err.code == 'ENOENT') {
                // Page not found
                fs.readFile(path.join(__dirname, '7 - Node.js/public', '404.html'), (err, content) => {
                    res.writeHead(404, { 'Content-Type': 'text/html' });
                    res.end(content, 'utf-8');
                });
            } else {
                // Some server error
                res.writeHead(500);
                res.end(`Server Error: ${err.code}`);
            }
        } else {
            // Success
            res.writeHead(200, { 'Content-Type': contentType });
            res.end(content, 'utf-8');
        }
    });

});

const PORT = process.env.PORT || 5000; /* Look first for the environment variable, port 5000 as fallback */

server.listen(PORT, () => console.log(`Server running on PORT ${PORT}!`));