"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeESLintConfig = normalizeESLintConfig;
exports.normalizeBabelParseConfig = normalizeBabelParseConfig;

var _core = require("@babel/core");

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function normalizeESLintConfig(options) {
  const {
    babelOptions = {},
    ecmaVersion = 2020,
    sourceType = "module",
    allowImportExportEverywhere = false,
    requireConfigFile = true
  } = options,
        otherOptions = _objectWithoutPropertiesLoose(options, ["babelOptions", "ecmaVersion", "sourceType", "allowImportExportEverywhere", "requireConfigFile"]);

  return Object.assign({
    babelOptions,
    ecmaVersion,
    sourceType,
    allowImportExportEverywhere,
    requireConfigFile
  }, otherOptions);
}

function normalizeBabelParseConfig(options) {
  var _options$babelOptions, _options$babelOptions2;

  const parseOptions = Object.assign({
    sourceType: options.sourceType,
    filename: options.filePath
  }, options.babelOptions, {
    parserOpts: Object.assign({
      allowImportExportEverywhere: options.allowImportExportEverywhere,
      allowReturnOutsideFunction: true,
      allowSuperOutsideMethod: true
    }, options.babelOptions.parserOpts, {
      plugins: ["estree", ...((_options$babelOptions = (_options$babelOptions2 = options.babelOptions.parserOpts) == null ? void 0 : _options$babelOptions2.plugins) != null ? _options$babelOptions : [])],
      ranges: true,
      tokens: true
    }),
    caller: Object.assign({
      name: "@babel/eslint-parser"
    }, options.babelOptions.caller)
  });

  if (options.requireConfigFile !== false) {
    const config = (0, _core.loadPartialConfig)(parseOptions);

    if (config !== null) {
      if (!config.hasFilesystemConfig()) {
        throw new Error(`No Babel config file detected for ${config.options.filename}. Either disable config file checking with requireConfigFile: false, or configure Babel so that it can find the config files.`);
      }

      return config.options;
    }
  }

  return parseOptions;
}