# Node.js Foundation LTS Meeting Minutes 2015-06-29

Recording: https://youtu.be/L_8eDAFhCwc

## Present

* Rod Vagg @rvagg
* Ali Ijaz Sheikh @ofrobots
* Michael Dawson @mhdawson
* Ben Noordhuis @bnoordhuis
* James Snell @jasnell
* Dan Shaw @dshaw
* Trevor Norris @trevnorris

## Agenda

* Breaking changes between v0.12.x and next LTS releases cycle: https://github.com/nodejs/LTS/issues/10
* Stock-take the resources (individuals, companies providing people time) we have available to maintain at least 3 LTS branches, likely more: 0.10, 0.12, possible io.js branches, future LTS—possibly multiple
* 0.10 maintenance, what plans can we formulate at this stage, what do we communicate to users
* 0.12 maintenance, plans and communication
* V8 support, how, who, what can we realistically expect to be able to do & offer here
Begin to formulate future LTS plan; connection with discussions here: nodejs/io.js#1997 and here: #8 (recap the final sections of those two threads for most relevant proposals).
* Formulate some thresholds for backporting; we have a pending PR to pull some fixes in to io.js 1.8 but we haven't come up with a threshold of what should make it in so I've been stalling on my part.

## Minutes

### Breaking changes between 0.12 and next LTS

* Julien: wiki page that we’re building: https://github.com/nodejs/LTS/wiki/Breaking-changes-between-v0.12-and-next-LTS-release
* Julien: decide whether we need an 0.14 release cycle or what work we need to do to make sure the transition is smooth
* Julien: don’t expect to need an 0.14, idea was to document the changes and communicate that there was no need for an 0.14; having them documented makes it possible to make the transition easy enough
* James: 0.14 was suggested _if_ the changes were major enough that we needed a transition, alternatively just making the jump would be like “ripping the band-aid off”.
* Dan: Does this include C++ changes?
* Julien: Yes, we need to make sure that NAN covers this. io.js has forced a lot of upgrade in OSS modules but there are lot of enterprise, closed-source modules.
* Julien: Can we have sign-off from the LTS group on this list please?
* Dan: what is the status of Intl here?
* James: still to be determined, Steve Loomis and I are still figuring some of these items out. Assumption is that it will be _at least_ what is in 0.12.
* Rod: there are other changes, often semver-minor, that have caused breakage unintentionally, we should try and capture some of them if possible, although that’s tricky. (Rod TODO: make an issue on io.js to ask for help collecting info on these issues).
* Julien: we need to work in collaboration with the evangelism group to encourage users to start trying this out when we release RCs.
* Dan & James: encourage build & benchmarking groups to get involved in helping with testing compatibility and understanding breakage.
* Julien: Action item: start work on a module testing platform for LTS, with James and Michael who have something in IBM to do this already.
* Rod: https://github.com/rvagg/iojs-smoke-tests useful in smoke testing modules against io.js releases

### Resources available

* Rod: worth taking stock of what resources companies have in making this work and providing people-resources.
* Dan: NodeSource have enterprise customers where LTS is of vital importance so we are keenly interested in putting resources in. Market is very stuck at 0.10 so we are well served keeping that as an option even if it may not be the right choice.
* James: IBM are in the same position, although have a focus on IBM platforms
* Ben: same for StrongLoop, will likely have Ben, Bert and Sam (but mostly Ben).
* Discussion about the next LTS & where io.js fits - agreement that next LTS would be from the converged stream.

### 0.10 maintenance
### 0.12 maintenance

* Discussed community feedback on what people _want_ from LTS
* James: it seems that an expected upgrade cycle of around 18 months is reasonable for the group we have feedback from already. https://github.com/nodejs/LTS/issues/8
* James: ideally we’d like to get people off 0.10 in the next year. Maintain 0.10 for a year beyond when we release a new LTS, or at least an RC.
* Michael: this would assume we have 3 LTSs in play. Another alternative would be to start putting pressure to get people to move up to 0.12 and drop 0.10 support when next LTS is rolled out.
* Julien: 0.10 is currently called maintenance rather than LTS.
* Rod: we could message this as 0.10 and 0.12 are maintenance releases and the new converged work is the first LTS. Also, can we shorten 0.10 lifecycle?
* James: perhaps 12 months for 0.10 and 18 months for 0.12.
* Julien: the npm stats were an eye-opener, we could use them as we move on to determine how well we are proceeding.
* Discussion around giving people a reason to upgrade rather than letting it drag on forever.
* Discussion around a strawman LTS plan: roll with 12 months for 0.10 and 18 months for 0.12 from new LTS.

### LTS Plan

* James: proposal: 1 LTS release per year
* Dan: preference for releasing at the same time of year.
* Discussion about https://github.com/nodejs/io.js/issues/1997 discussion, particularly about the proposal to have master lasting for a year.
* Rod: ideally we should come up with a plan for LTS and push that back on the non-LTS release discussion.

**Summary of LTS plan**

* Julien: LTS once a year for 18 months released at the same time of year, 0.10 for 12 months, 0.12 for 18 months from when we get an LTS out.
* Discussion around 0.12 and the 18 months vs 12 months.
* Discussion around “maintenance” vs full LTS: security only
* James to write up an initial LTS strawman plan.

* Moved on to discussion on V8, agreed to keep it for next meeting

* Michael: scope for this group - e.g. what should we incorporate here for future planning work.

### Backporting thresholds

_skipped_

## Next meeting

* July 6th, 2015 8pm UTC

Deferred items:

* Backporting thresholds
* V8 maintenance
