# Attendees

* Myles Borins
* Michael Dawson
* Jeremiah Senkpiel
* Ali Sheikh
* Michael Hablich
* Franziska Hinkelmann
* Rod Vagg

# Agenda

* Managing v8 floating patches
* v4.5
* Exporting ssl symbols on windows

# Discussion

## Managing v8 floating patches - https://github.com/nodejs/LTS/issues/111

* V8 team willing to have place where floating patching can land
* Overlap of 2-3 weeks were still maintained that might cause conflicts
* would need to create separate branch for node.
* Why not create fork
* Notes from Ben N
  * What timeframe for using google infrastructure
  * We have our own infra and can run from Node tree

### Infrastructure
* Chromium infrastructure team is moving fast and deprecating lots of things so may
  not support v8 version older than 1 year.
* Will need special (LTS like) support for Node.
* Jeremiah, backport changes need to allow older tests to run on new infra.
* Can still run locally, but cannot run old way in google infra.
* Michael (google) not a feasible option to run Node.js older branches
  after a few months.
* Google may be able to assist in adding resources to the Node CI.
* Conclusion is that its not feasible to use Google infra.

### Reviews
* Jeremiah - what are the ideas on this front
* Ali, Bookkeeping is also something we want to take care of, would it
  make sense to have intermediate v8 fork.  Benefit no noise on that repo.
  It would be v8 + only patches node needs.  Ali does a lot of the merging,
  direct fork would be easier to maintain.  Would also let us loop
  in the v8 team.
* Michael (D), how will google v8 reviewers get hooked in.
  So far Ali has been pulling in google people for specific reviews.
  Often pulling in an existing fix, so already reviewed so decision
  is mostly around whether it makes sense to backport and if does not
  apply cleanly then getting the originator to review.
  Start with a few people like Ali who will watch and the
  add on additional reviewers.
* Ali to write up proposed flow in the issue for discusion in
  github

## v4.5

* List of semver minor issues staged, discussed to get agreement
  that they can all go in- https://github.com/nodejs/LTS/issues/120

  * Most had been agreed earlier, 2 others were discussed in more
    detail.  Agreed we should include the 2 new ones:

    * [1aa9c318c9] - (SEMVER-MINOR) repl: copying tabs shouldn't
      trigger completion (Eugene Obrezkov) #5958

    * [2e4fb99a86] - (SEMVER-MINOR) src: add node::FreeEnvironment
      public API (Cheng Zhao) #3098

* Myles asked that people review the changelog.

* 1.9.1 libuv is included in 4.5, want aggressive testing so Myles
  to contact npm to ask them to do testing, and will follow up offline
  with Rod who else we should ask to do testing.

* Rod suggested we add flag to also discuss his in CTC meeting. Myles
  did that.

## Exporting ssl symbols on windows

* Ben asked that we consider: https://github.com/nodejs/node/pull/7676

* Landed about 8 days ago, so not likely a candidate for 4.5 release.
  Discussion around whether it can cause addon breakage.

* Original issue: https://github.com/nodejs/node-v0.x-archive/issues/4051
  was open for almost 4 years.

* Maybe we need Ben to talk to this, take offline to get more post-mortem
  writeup so that we can make the right decision.

* Rod, may want to put on hold to let bake in 6 for a little while
  and if we see it solving problems for modules we may see
  demand to pull back.  If it solves openssl issue for
  big interger module he is maintaining then he'd be quite
  interested

## Please review LTS README redo - https://github.com/nodejs/LTS/pull/121

* It was requested that we all review this one.
