# Node.js LTS meeting 05 June 2017

- [Github Issue](https://github.com/nodejs/LTS/issues/225)
- [Meeting Video](https://www.youtube.com/watch?v=xSo6YiKzc5M)
- [Previous meeting](https://github.com/nodejs/LTS/issues/213)
- Next meeting: 26 June 2017


## Present

- James Snell
- Jeremiah Senkpiel
- Myles Borins
- Michael Dawson
- Sam Roberts
- Gibson Fahnestock


## Minutes

### Chartering the Release Team as a Working Group [nodejs/CTC#123](https://github.com/nodejs/CTC/issues/123)

- James: we need to make sure we involve the other release team members
  (evanlucas, cjihrig, italoacasas).
- Myles: We don’t want to start forcing people to come to meetings
- Myles: Maybe we could have a quarterly meeting for release and backporting
  teams to come together and discuss WG stuff.
- Gibson: Is there anything that the LTS team would do that isn’t covered by
  the sub-teams?
- Myles: Doesn’t seem like it.
- Myles: It would be good to make it so that it’s easier for people to get
  involved in LTS without needing to give them permissions, we had Nathan from
  ember-cli who wanted to get involved for example.
- Myles: This might start to get convoluted.
- James: I think we just have one overarching team that includes a releasers
  team and a backporting team.
- Myles: Okay, then should we just call the top-level WG Release and the
  teams LTS and Releasers.
- James: we need to be really clear about the what the Release team are, are we
  talking about changing the names?
- Jeremiah: The name for the current release team doesn’t need to be really
  concise, they don’t get mentioned much.
- James: So we’re all agreed on the structure, we can just bikeshed the names,
  the names below are not decided on, maybe we can come up with better ones:

1. The overarching Release Working Group - name is TBD, some good ideas wanted
2. The Releasers team, who have permissions to actually build and publish releases
3. The Backport team, who have permission to land commits on LTS branches
4. The CitGM team

- Myles: Open question: does group 1 vote on whether PRs will go into LTS, or just group 3?
- James: Why not just say that only people in one of the subteams can vote.
- Jeremiah: Teams are cheap on Github, so we can always have more teams.
- Myles: True, but that adds to the cognitive load.
- Gibson: This only applies to people who’ve done enough to join the WG, but
  aren’t planning to do the work to join one of the subteams. Not sure this
  will ever be non-academic.
- Myles: So what should the top-level team be called?
- All: Let’s take this bikeshed offline.
- Jeremiah: WRT naming, I think the key thing is to make it clear for outsiders
  to our process (what does this WG actually mean?)
- Sam: ^---- agree with Jeremiah on clarity for outsiders, which is what makes a
  Release WG and a Release Team problematic, IMO, because it’s using the same
  word for the whole and a part. But I can’t think of better names.
- Myles: Maybe we could have a schedule for current releases as well, like
  we’ve been doing for LTS. That might be something we could discuss in
  Quarterly meetings.
- Jeremiah: I think every other week is a reasonable cadence, I’d want to make 
- Gibson: Should we invite the release team to the next meeting?
- Michael: don’t want to drag them into a meeting off the bat.
- James: I think we should do both, let’s aim to make a decision at the next
  meeting, and make sure we get release involved before then.
- Myles: We should evaluate which of the tools we use for releases might fall
  under the purview of the release team (e.g. installers, branch-diff,
  changelog-maker, blogpost-maker, the releases themselves, citgm)
- James: I think several of the tools we use should be brought into the
  foundation, and maybe come under release (like branch-diff). The installers
  is currently a self-contained thing.
- James: I think CitGM is a good example, build provides the machines to run
  CitGM on (and to run tests on) but the CitGM team owns the code.
- Myles: It just seems weird to me that release is this thing with loads of
  floating bits, is there value in bringing them all together.
- Michael: I don’t see it’s useful to suck them all into releases.
- James: Keeping CitGM under release WG makes it easier to do things like
  enforce it for releases.
- Michael: We require test runs though, tests don’t come under release
- James: I think we should bring CitGM in from the start.
- Myles: I think this is going to get even bigger, there will be other teams
  coming under the Release WG.
- Michael: The important thing is to make sure it’s easy for people to join
  later.
- James: So if we include CitGM, are we giving them new responsibility?
- Myles: No, the WG doesn’t have any special responsibility unless you're in a
  particular team.
- Myles: We need to check with @nodejs/build to make sure team permissions get
  updated (e.g. on CI).
- James: Need to update the LTS repo name to WG name, and update the Github teams.
- James: Governance?
- Michael: Already in the PR.
- Myles: We need to make sure redirects actually work.
- James: It should, but yes.
- James: The governance process follows the boilerplate, we should all go
  through and make sure it’s actually correct, it’s pretty heavyweight. For
  example we need to make sure we’re clear that people don’t have to start
  joining meetings.
- James: We need to be clear in the governance about the process for removing
  someone from the release team.


### Shipping V8 in Node 8 [nodejs/node#13263](https://github.com/nodejs/node/pull/13263)

- Myles: 5.8 has been patched for 6.0, but 5.9 doesn’t have the patches in the
  PR.
- Myles: The patch would take a day or two to put together.
- James: When does 6.0 get released?
- Myles: 6 weeks.
- Myles: There’s already been an API/ABI freeze on 6.0 (which is what we cut
  against).
- Myles: I’d almost opt to skip 5.9 and go with 6.0, there will be lots of
  fixes in 6.0 for regressions in 5.9.
- Myles: I can ask the V8 team.
- All: we shouldn’t land the 5.9 update on 8.x until it has the 6.0 patch.
- Myles: If it’s going to take us 3 weeks to stabilise on 5.9, for 3 weeks
  advance notice of 5.9, then it’s not really worthwhile.
- Jeremiah: We should consider having a branch that has 5.9.
- Gibson: Could we use master for that?
- Jeremiah: Maybe, I’m not sure whether people actually use master.
- James: Looks like we could have some pushback on not landing the 5.9 PR
  without the ABI patch.
- Myles: The ABI patch for 5.8 never landed on master.
- Gibson: I’ll make an issue for this.
- Myles: Do master and 8 have the same module version right now?
- James: No, 8.x is 57 and master is 55.
- Myles: okay, then I’m okay with 5.9 landing on master as long as it bumps the
  module version to 56, or bump to 57 if it has the API patch.
- James: we need to be very clear about what V8 changes to backport from master
  to 8.x.
- Jeremiah: I think landing with the ABI patch would still be preferrable
  though.
