# Node.js Foundation Release WorkGroup Meeting 2019-06-20

## Links

* **Recording**: https://www.youtube.com/watch?v=IDJWHNgiMGE&t=398s
* **GitHub Issue**: https://github.com/nodejs/Release/issues/460

## Present

* Beth Griggs (@BethGriggs)
* Myles Borins (@MylesBorins)
* Richard Lau (@richardlau)
* Sam Roberts (@rsam)
* Ruben Bridgewater (@BridgeAR)

## Agenda

## Announcements
 
*Extracted from **Release-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/Release

* A proposal for changes to LTS [#458](https://github.com/nodejs/Release/issues/458)
  * Current state: 
    * LTS Releases 6 months in current, 18 months in Active LTS, 12 months in maintenance
    * Aim for monthly release during active, no determined schedule for releases during maintenance 
    * Generally avoid SEMVER-MINORS during maintenance
  * This proposal swaps active to 12 months and maintenance to 18 months
    * No longer have overlapping Active LTS releases
    * More accurately reflects the release teams capacity to do releases
  * We should make a decision before v12.x goes into Active LTS
  * (Action) Raise a PR changing and use approvals on that to gain consensus

* Proposal: Stop specifying patch or minor for LTS releases [#449](https://github.com/nodejs/Release/issues/449)
  * Needs user research
  * Concerns: 
    * Users typically want less SEMVER-MINORS in LTS releases for stability
    * Platforms and downstream distributions take a longer time to upgrade to SEMVER-MINOR than a PATCH
    * All LTS release would be SEMVER-MINOR and this could be a burden on consumers
  * Landing commits in order might not make things easier as there will still be commit gaps 
  * Most of the burden is in the manual auditing of commits not landing
  * Sam found when backporting TLS 1.3 that order was significant
  * Hard to trial this proposal
  * (Sam) My experience is that users are reluctant to upgrade in general
  * Do we believe SEMVER-MINORS are more risky?
    * Likely to be more buggy as they've had less time to mature
    * Does it matter if there are bugs in new features? 
    * LTS implies stability, so we shouldn't be adding unstable features
  * Alternative proposal:
    * Only land commits with LTS watch labels on them
    * Landing significantly less
    * Onus on collaborators to label things that need to go to LTS
    * Smaller LTS releases
  * Proposal regarding multiple branches [#420](https://github.com/nodejs/Release/pull/420): 
    * Concerns: 
        * Cannot change history of the vN.x branches, cannot force-push
        * Downstream users floating patches on release lines
 * Module maintainer point of view
    * May benefit from SEMVER-MINORs in older LTS releases due to more consistent feature availability across release lines
    * But if SEMVER-MINORs don't go back, incentive to upgrade
 * Suggestion of recruiting more LTS members/releasers to go through the process
 * (Action) User survey of expectations of LTS


* Defining a word for all current releases [#359](https://github.com/nodejs/Release/issues/359)
  * Need to PR this change
* Development kit and Deployment kit releases [#341](https://github.com/nodejs/Release/issues/341)
  * Work with Build WG
  * Myles check with TSC before doing so
  * Check the Release team are in sync with Node.js core
  * Start a thread with TSC

## Q&A, Other

* (Richard) Will the security update happen? 
  * Nothing to ship
  * OpenSSL updates can go in regular releases as they are public updates
  * Will not schedule security releases going forward 

## Upcoming Meetings

* **Node.js Foundation Calendar**: https://nodejs.org/calendar
