# Node.js Release WorkGroup Meeting 2020-03-12

## Links

* **Recording**:  https://www.youtube.com/watch?v=eTMv2pQIKfU
* **GitHub Issue**: https://github.com/nodejs/Release/issues/546
* **Minutes Google Doc**: https://docs.google.com/document/d/1AuGvlqPg_XVihWPFOaOJKYeXD8wDZN3DKyQeYQFtY9w/edit

## Present

* Beth Griggs (@BethGriggs)
* Darcy Clarke (@darcyclarke)
* Michael Zasso (@targos)
* Myles Borins (@mylesborins)
* Richard Lau (@richardlau)
* Shelley Vohr (@codebytere)

## Agenda

## Announcements

* Nominating Richard Lau (@richardlau) for the LTS and backporters team [#550](https://github.com/nodejs/Release/issues/550)

### nodejs/Release

* Working out a policy around reverts for LTS branches [#535](https://github.com/nodejs/Release/issues/535)
  * Discussed last meeting - no specific actions.
  * Should it be reverted on master first, and then bubble down to LTS?
    * Consensus was that we should decide on a case-by-case basis.
  * Documentation on what we should do if a release has a confirmed bug.
    * Potentially including raising an issue on Release repository when something goes wrong.
  * We should aim to revert PRs in master as soon as possible.

* Dropping the backporters team - [#547](https://github.com/nodejs/Release/issues/547)
  * Myles suggestion in [#547](https://github.com/nodejs/Release/issues/547#issuecomment-596644900)
  * We’re currently mixing the model of IAM and working streams.
  * We want to encourage more people backporting.
  * Should more than just releasers/backporters land on staging branches?
  * At the moment it’s a small group so we don’t conflict with each other when landing PRs on staging branches and backports.
  * Bottleneck is the time it takes for backport PRs.
  * Do we want the LTS team to be able to have an opinion on what should land without having access to land PRs on staging branches?
  * The questions we’re trying to answer are:
     * Who has permission to land things on the branches?
     * And who can participate in the discussions?

## Q&A, Other

* The definition of done is currently when a commit lands on master - maybe we should change this?
  * (Shelley) Checks API to show if a PR will land cleanly on LTS branches.
  * (Richard) Is there a risk of alienating drive-by contributors?
  * (Shelley) Doesn’t need to block merge.
  * (Myles) We could show through labels - we already use `backport-requested` labels.
  * (Myles) We want to avoid premature backports.
  * (Beth) Does this mean backports could be raised before the LTS team has audited eligibility?
  * (Richard) We should work on the flow.
  * **Action**: Raise an issue to discuss flow and/or prototype.

* Create an offboarding document [#542](https://github.com/nodejs/Release/issues/542)
* `node-core-utils` now has an option for landing backports `git node land --backport`
* Shelley is working on automating the steps involved with creating release commits in `node-core-utils`
  * Call for releasers to try it out and review.

## Upcoming Meetings

* **Node.js Foundation Calendar**: https://nodejs.org/calendar

Click `+GoogleCalendar` at the bottom right to add to your own Google calendar.


